IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_REGISTRA_CREDITO_CARTAO_COMMERCE')
BEGIN
	DROP TRIGGER TRG_REGISTRA_CREDITO_CARTAO_COMMERCE
END
GO

CREATE TRIGGER [dbo].[TRG_REGISTRA_CREDITO_CARTAO_COMMERCE]
ON [dbo].[RC_DEB]
AFTER INSERT, UPDATE
AS
BEGIN
    SET NOCOUNT ON;
	
	DECLARE @CD_NF_NEW INT = ISNULL((SELECT TOP 1 CD_NF FROM INSERTED),0)
	DECLARE @CD_NF_OLD INT = ISNULL((SELECT TOP 1 CD_NF FROM DELETED),0)

    IF NOT EXISTS (SELECT 1 FROM inserted WHERE isnull(cd_nf,0) > 0)
		OR EXISTS(
				SELECT 1 FROM RC_CRED CRED
							inner join inserted i on i.cd_rc_deb = cred.cd_rc_deb and i.cd_filial = cred.cd_filial
			)
		OR @CD_NF_NEW = @CD_NF_OLD
        RETURN;
	BEGIN TRY

		DECLARE @Processar TABLE (
			CD_EMP INT,
			CD_FILIAL INT,
			CD_RC_DEB INT,
			CD_DP_LANC INT,
			DT_PAG DATE,
			VL_PGTO DECIMAL(18,2),
			VL_JUR DECIMAL(18,2),
			VL_DESC DECIMAL(18,2),
			CD_HIST INT,
			CD_USU INT,
			HIST VARCHAR(255),
			CD_CNT INT,
			CD_DOC INT,
			VLR_COMIS DECIMAL(18,2),
			VLR_GLOSA DECIMAL(18,2),
			VLR_IMPOSTO DECIMAL(18,2),
			VLR_TAXA DECIMAL(18,2),
			VLR_PAG DECIMAL(18,2),
			NR_CARTAO VARCHAR(20),
			CD_SEGURANCA VARCHAR(10),
			VALIDADE VARCHAR(10),
			NR_AUTORIZACAO VARCHAR(20),
			CPF VARCHAR(14),
			NSU VARCHAR(20),
			BANDEIRA VARCHAR(20),
			CD_TIPO_CARTAO INT,
			QTDE_PARC INT,
			TRN_POS VARCHAR(20)
		);

		INSERT INTO @Processar
		SELECT SAI.CD_EMP,
			   SAI.CD_FILIAL,
			   DEB.CD_RC_DEB,
			   1 AS CD_DP_LANC,
			   VD.DT_EMI_PED,
			   DEB.VLR_DP,
			   0, 0, 0, 1,
			   CONCAT('RECEBTO DUP. N ', DEB.NR_DP,'-',DEB.PARC, ' FIL.: ', SAI.CD_FILIAL, ' - ', CLI.NM_FANT),
			   0, 4, 0, 0, 0, 0,
			   VG_PAG_CARTAO.VLR_PAG,
			   VG_PAG_CARTAO.NR_CARTAO,
			   VG_PAG_CARTAO.CD_SEGURANCA,
			   VG_PAG_CARTAO.VALIDADE,
			   VG_PAG_CARTAO.NR_AUTORIZACAO,
			   VG_PAG_CARTAO.CPF,
			   VG_PAG_CARTAO.NSU,
			   VG_PAG_CARTAO.BANDEIRA,
			   VG_PAG_CARTAO.CD_TIPO_CARTAO,
			   VG_PAG_CARTAO.QTDE_PARC,
			   VG_PAG_CARTAO.TRN_POS
		FROM EST_PED_VD VD
		INNER JOIN est_ped_vd_pag VD_PAG ON VD.CD_PED = VD_PAG.CD_PED AND VD.CD_FILIAL = VD_PAG.CD_FILIAL
		INNER JOIN est_ped_vd_pag_cartao VG_PAG_CARTAO ON VD_PAG.CD_PED = VG_PAG_CARTAO.CD_PED AND VD_PAG.CD_FILIAL = VG_PAG_CARTAO.CD_FILIAL
		INNER JOIN est_nf_sai SAI ON SAI.CD_PED = VG_PAG_CARTAO.CD_PED AND SAI.CD_FILIAL = VG_PAG_CARTAO.CD_FILIAL
		INNER JOIN INSERTED DEB ON DEB.CD_NF = SAI.CD_NF AND DEB.CD_FILIAL = SAI.CD_FILIAL
		INNER JOIN RC_CLI CLI ON CLI.CD_CLI = VD.CD_CLI
		WHERE NOT EXISTS (
			SELECT 1 FROM RC_CRED CRED WHERE CRED.CD_RC_DEB = DEB.CD_RC_DEB AND CRED.CD_FILIAL = DEB.CD_FILIAL
		);

		INSERT INTO RC_CRED_PAG_CARTAO (
			CD_EMP, CD_RC_DEB, CD_FILIAL,
			VLR_PAG, NR_CARTAO, CD_SEGURANCA,
			VALIDADE, NR_AUTORIZACAO, CPF, NSU,
			BANDEIRA, CD_TIPO_CARTAO, QTDE_PARC, TRN_POS
		)
		SELECT DISTINCT 
			CD_EMP, CD_RC_DEB, CD_FILIAL,
			VLR_PAG, NR_CARTAO, CD_SEGURANCA,
			VALIDADE, NR_AUTORIZACAO, CPF, NSU,
			BANDEIRA, CD_TIPO_CARTAO, QTDE_PARC, TRN_POS
		FROM @Processar;

		INSERT INTO RC_CRED (
			CD_EMP, CD_FILIAL, CD_RC_DEB, CD_DP_LANC, DT_PAG,
			VL_PGTO, VL_JUR, VL_DESC, CD_HIST, CD_USU,
			HIST, CD_CNT, CD_DOC, VLR_COMIS, VLR_GLOSA,
			VLR_IMPOSTO, VLR_TAXA
		)
		SELECT DISTINCT 
			CD_EMP, CD_FILIAL, CD_RC_DEB, CD_DP_LANC, DT_PAG,
			VL_PGTO, VL_JUR, VL_DESC, CD_HIST, CD_USU,
			HIST, CD_CNT, CD_DOC, VLR_COMIS, VLR_GLOSA,
			VLR_IMPOSTO, VLR_TAXA
		FROM @Processar;
	END TRY
	BEGIN CATCH
		RETURN;
	END CATCH
END
